define("modules/clean/js_basic_stopwatch",["require","exports","modules/core/exception"],function(t,e,i){"use strict";function n(t,i,n,o){return r?new s(t,i,n,o):e.NoopStopwatchInstance}Object.defineProperty(e,"__esModule",{value:!0});var o,r=!(!window.performance||!window.performance.now),a=0;(function(t){t[t.Span=1]="Span",t[t.AsyncSpan=2]="AsyncSpan",t[t.Trace=3]="Trace"})(o=e.TimingDataType||(e.TimingDataType={}));var s=(function(){function t(t,e,i,n){this.stopwatchName=t,this.strictAssert=e,this.reportSpanFn=i,this.activeSpans={},this.spanStack=[],this.stopwatchTags=n||[]}return t.prototype.reset=function(){this.activeSpans={},this.spanStack=[]},t.prototype.newSpanID=function(){var t=String(a);return a++,t},t.prototype._resolveTime=function(t){return void 0===t&&(t=window.performance.now()),Math.round(t)},t.prototype._resolveParent=function(t){if(t.type!==o.Span)return void(t.parent="");var e=this.spanStack[this.spanStack.length-1];if(e)if(e!==t.name)this._report_sw_misuse("Closing "+e+" while the latest open span is "+t.name+".\n        You are either mixing sync and async spans or closing sync spans out of order.");else{this.spanStack.pop();for(var i="",n=0,r=this.spanStack;n<r.length;n++){var a=r[n];i+=a+"#"}t.parent=i}else this._report_sw_misuse(t.name+' isn\'t a synchronous span and has to be started with "async:true".')},t.prototype.recordTrace=function(t,e){void 0===e&&(e={});var i=this._resolveTime(e.traceTime),n=this.newSpanID(),r=e.annotations||{},a={name:t,span_id:n,start_time:0,end_time:i,annotations:r,type:o.Trace,parent:""};return this.reportSpanFn&&this.reportSpanFn(this.stopwatchName,this.stopwatchTags,a),n},t.prototype.start=function(t,e){void 0===e&&(e={}),t||this._report_sw_misuse("Reporting a span without a name");var i=this._resolveTime(e.startTime);e.async||this.spanStack.push(t);var n=this.newSpanID(),r={name:t,span_id:n,start_time:i||0,annotations:{},type:e.async?o.AsyncSpan:o.Span};return t in this.activeSpans||(this.activeSpans[t]=[]),this.activeSpans[t].push(r),n},t.prototype.end=function(t,e){void 0===e&&(e={});var i=this.findTimerDataIndex(t,e.spanId);if(i!==-1){var n=this.activeSpans[t],o=n[i];n.splice(i,1),this._resolveParent(o);var r=this._resolveTime(e.endTime);return r<o.start_time?void this._report_sw_misuse("span "+t+" has set an endTime earlier than start_time"):(o.end_time=r,this.reportSpanFn&&this.reportSpanFn(this.stopwatchName,this.stopwatchTags,o),o.span_id)}},t.prototype.addSpanAnnotation=function(t,e,i,n){var o=this.findTimerDataIndex(t,n);if(o!==-1){this.activeSpans[t][o].annotations[e]=i}},t.prototype.findTimerDataIndex=function(t,e){if(!(t in this.activeSpans)||0===this.activeSpans[t].length)return this._report_sw_misuse("tried to find "+t+" but that span doesn't exist"),-1;var i=-1,n=this.activeSpans[t];if(void 0===e)i=0;else for(var o=0;o<n.length;o++)if(n[o].span_id===e){i=o;break}return i===-1&&this._report_sw_misuse("tried to find "+t+" with id "+e+" but that span doesn't exist"),i},t.prototype._report_sw_misuse=function(t){t="JSBasicStopwatch "+this.stopwatchName+": "+t,this.strictAssert?i.assert(!1,t):i.reportStack(t,{severity:i.SEVERITY.NONCRITICAL,tags:["log_js_stopwatch"]})},t})();e.JSBasicStopwatchImpl=s;var c=(function(){function t(){}return t.prototype.reset=function(){},t.prototype.start=function(t,e){void 0===e&&(e={})},t.prototype.end=function(t,e){void 0===e&&(e={})},t.prototype.recordTrace=function(t,e){void 0===e&&(e={})},t.prototype.addSpanAnnotation=function(t,e,i,n){},t})();e.NoopStopwatchInstance=new c,e.createStopwatch=n}),define("modules/clean/js_client_stopwatch",["require","exports","modules/core/xhr","modules/clean/js_basic_stopwatch","modules/constants/request","modules/core/browser","modules/core/exception"],function(t,e,i,n,o,r,a){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var s=(function(){function t(t){this.id=t}return t.REQUEST_ID=new t("dropbox.js_client_stopwatch.request_id"),t.CORRELATION_ID=new t("dropbox.js_client_stopwatch.correlation_id"),t.URL=new t("dropbox.js_client_stopwatch.url"),t})(),c=(function(){function t(){var t=this;this.GLOBAL_SW_NAME="GLOBAL_STOPWATCH",this.flush_interval=6e4,this.strictAssert=!1,this.intervalId=null,this._report_span_fn=function(e,i,o){e in t.storedAggregates||(t.storedAggregates[e]={});var r=t.storedAggregates[e],a=""+o.parent+o.name;a in r||(r[a]={name:o.name,start_time:o.start_time,total_time:0,num_calls:0,annotations:{},parent:o.parent||"",stopwatch_tags:i.length>0?i:void 0,type:o.type});var s=r[a];if(void 0===o.end_time)return void t._report_sw_misuse("Span "+a+" reported with undefined end_time");s.type===n.TimingDataType.Trace?(s.total_time=o.end_time-o.start_time,s.num_calls=1):(s.total_time+=o.end_time-o.start_time,s.num_calls+=1);for(var c in o.annotations)o.annotations.hasOwnProperty(c)&&(s.annotations[c]=o.annotations[c])},this.reset()}return t.prototype.reset=function(){this.stopwatches={},this.sentInitialData=!1,this.create_stopwatch(this.GLOBAL_SW_NAME),this.storedAggregates={},this.intervalId&&clearInterval(this.intervalId),this.intervalId=null},t.prototype.reset_individual_stopwatch=function(t){if(!this.stopwatch_exists(t))return void this._report_sw_misuse("tried to reset the stopwatch "+t+" but it does not exist");this.stopwatches[t].reset()},t.prototype.stopwatch_exists=function(t){return t in this.stopwatches},t.prototype.create_stopwatch=function(t,e){if(this.stopwatch_exists(t))return void this._report_sw_misuse("tried to create a new stopwatch "+t+" but it already exists");this.stopwatches[t]=n.createStopwatch(t,this.strictAssert,this._report_span_fn,e)},t.prototype.createDetachedStopwatch=function(t,e){return void 0===e&&(e={}),new _(t,this._report_span_fn,e.request_id,e.correlation_id,e.url,e.tags)},t.prototype.create_stopwatch_if_not_exist=function(t,e){this.stopwatch_exists(t)||this.create_stopwatch(t,e)},t.prototype.getStopwatch=function(t){return this.stopwatch_exists(t)?this.stopwatches[t]:(this._report_sw_misuse(t+" doesn't exist"),null)},t.prototype.recordTrace=function(t,e){void 0===e&&(e={});var i=this.getStopwatch(e.stopwatchName||this.GLOBAL_SW_NAME);if(null!=i){var n={traceTime:e.traceTime};return i.recordTrace(t,n)}},t.prototype.startSpan=function(t,e){void 0===e&&(e={});var i=this.getStopwatch(e.stopwatchName||this.GLOBAL_SW_NAME);if(null!=i){var n={startTime:e.startTime,async:e.async};return i.start(t,n)}},t.prototype.endSpan=function(t,e){void 0===e&&(e={});var i=this.getStopwatch(e.stopwatchName||this.GLOBAL_SW_NAME);if(null!=i)return i.end(t,{spanId:e.spanId,endTime:e.endTime})},t.prototype.addSpanAnnotation=function(t,e,i,n){void 0===n&&(n={});var o=this.getStopwatch(n.stopwatchName||this.GLOBAL_SW_NAME);null!=o&&o.addSpanAnnotation(t,e,i,n.spanId)},t.prototype.log_stored_results=function(){if(this.sentInitialData)return void this._report_sw_misuse("ClientStopwatch tried to log stored results, but the stopwatch is set to log immediately");this.flush_current_data(),this.sentInitialData=!0,this.intervalId=setInterval(this.flush_current_data.bind(this),this.flush_interval)},t.prototype._report_sw_misuse=function(t){t="ClientStopwatch: "+t,this.strictAssert?a.assert(!1,t):a.reportStack(t,{severity:a.SEVERITY.NONCRITICAL,tags:["log_js_stopwatch"]})},t.prototype.flush_current_data=function(){for(var e in this.storedAggregates)if(this.storedAggregates.hasOwnProperty(e)){var i=this.storedAggregates[e],n={};if(Object.keys(i).length>t.MAXSPANS){var o=0;n[e]={};for(var r in i)i.hasOwnProperty(r)&&(n[e][r]=i[r],o===t.MAXSPANS&&(t.send_spans(n),o=0,n[e]={}),o++)}else n[e]=i;0!==Object.keys(n[e]).length&&t.send_spans(n)}this.storedAggregates={}},t.send_spans=function(t){var e=JSON.stringify(t),n={request_id:o.REQUEST_ID,url:r.get_href(),aggregated_sw_data:e};i.sendXhr("/log_js_sw_data",n)},t.prototype.print_stopwatches_debug=function(){var t=this.get_debug_data();console.table&&console.groupCollapsed&&console.groupEnd&&(console.groupCollapsed("Request timeline"),console.table(t),console.groupEnd())},t.prototype.get_debug_data=function(){var t=[];for(var e in this.storedAggregates)if(this.storedAggregates.hasOwnProperty(e)){var i=this.storedAggregates[e];for(var o in i)if(i.hasOwnProperty(o)){var r=i[o],a={stopwatchName:e,spanName:r.name,time:r.start_time+r.total_time};r.type!==n.TimingDataType.AsyncSpan&&r.type!==n.TimingDataType.Span||(a.startTime=r.start_time),r.type===n.TimingDataType.Span&&(a.info="Total time: "+r.total_time+"ms"),t.push(a)}}return t.sort(function(t,e){return t.time-e.time}),t},t.MAXSPANS=2e3,t})();e.JSStopwatch=new c;var _=(function(){function t(t,e,i,o,r,a){var s=this;this.sentInitialData=!1,this.strictAssert=!1,this.cachedSpans=[],this.reportSpan=function(t,e,i){s.sentInitialData?(s.updateAnnotations(i),s.reportSpanFn(t,e,i)):s.cachedSpans.push({stopwatchName:t,tags:e,timingData:i})},this.stopwatch=n.createStopwatch(t,this.strictAssert,this.reportSpan,a),this.request_id=i,this.correlation_id=o,this.url=r,this.reportSpanFn=e}return t.prototype.startSpan=function(t,e){void 0===e&&(e={});var i={startTime:e.startTime,async:e.async};return this.stopwatch.start(t,i)},t.prototype.endSpan=function(t,e){return void 0===e&&(e={}),this.stopwatch.end(t,{spanId:e.spanId,endTime:e.endTime})},t.prototype.addSpanAnnotation=function(t,e,i,n){this.stopwatch.addSpanAnnotation(t,e,i,n)},t.prototype.recordTrace=function(t,e,i){var n={};if(this.request_id&&(n[s.REQUEST_ID.id]=this.request_id),this.url&&(n[s.URL.id]=this.url),i)for(var o in i)i.hasOwnProperty(o)&&(n[o]=i[o]);var r={traceTime:e,annotations:n};this.stopwatch.recordTrace(t,r)},t.prototype.logData=function(){var t=this;if(this.sentInitialData)return void this.reportMisuse("ClientStopwatch tried to log stored results, but the stopwatch is set to log immediately");this.cachedSpans.forEach(function(e){t.updateAnnotations(e.timingData),t.reportSpanFn(e.stopwatchName,e.tags,e.timingData)}),this.cachedSpans=[],this.sentInitialData=!0,setTimeout(function(){e.JSStopwatch.flush_current_data()},0)},t.prototype.reportMisuse=function(t){t="ClientStopwatch: "+t,this.strictAssert?a.assert(!1,t):a.reportStack(t,{severity:a.SEVERITY.NONCRITICAL,tags:["log_js_stopwatch"]})},t.prototype.updateAnnotations=function(t){this.request_id?t.annotations[s.REQUEST_ID.id]=this.request_id:delete t.annotations[s.REQUEST_ID.id],this.correlation_id?t.annotations[s.CORRELATION_ID.id]=this.correlation_id:delete t.annotations[s.CORRELATION_ID.id],this.url?t.annotations[s.URL.id]=this.url:delete t.annotations[s.URL.id]},t})()}),define("modules/clean/perf_tools/browser_perf_utils",["require","exports","modules/core/browser","modules/core/xhr","modules/constants/request","modules/clean/js_client_stopwatch","modules/constants/webtiming"],function(t,e,i,n,o,r,a){"use strict";function s(t){c(t),_(t)}function c(t){var e=i.performance();if(e&&e.getEntriesByType){var n=r.JSStopwatch.createDetachedStopwatch("performance_marks",{correlation_id:t}),o=e.getEntriesByType("mark");if(o instanceof Array)for(var a=0,s=o;a<s.length;a++){var c=s[a];n.recordTrace(c.name,c.startTime)}n.logData()}}function _(t){var e=i.performance();if(e&&e.timing){var s=e.timing,c={navigation_start:s.navigationStart,unload_event_start:s.unloadEventStart,unload_event_end:s.unloadEventEnd,redirect_start:s.redirectStart,redirect_end:s.redirectEnd,fetch_start:s.fetchStart,domain_lookup_start:s.domainLookupStart,domain_lookup_end:s.domainLookupEnd,connect_start:s.connectStart,secure_connect_start:s.secureConnectionStart,connect_end:s.connectEnd,request_start:s.requestStart,response_start:s.responseStart,response_end:s.responseEnd,dom_loading:s.domLoading,dom_interactive:s.domInteractive,dom_content_loaded_event_start:s.domContentLoadedEventStart,dom_content_loded_event_end:s.domContentLoadedEventEnd,dom_complete:s.domComplete,load_event_start:s.loadEventStart,load_event_end:s.loadEventEnd},_={};_.request_id=o.REQUEST_ID,_.referrer=document.referrer;var l=r.JSStopwatch.createDetachedStopwatch("browser_perf",{correlation_id:t});for(var u in c)c.hasOwnProperty(u)&&(_[u]=c[u],c[u]&&l.recordTrace(u,c[u]-s.navigationStart));l.logData(),a.LOG_BROWSER_PERFORMANCE_INFO&&n.sendXhr("/alternate_wtl_browser_performance_info",_)}}Object.defineProperty(e,"__esModule",{value:!0}),e.logBrowserPerfData=s,e.logBrowserPerformanceInfo=_}),define("modules/clean/perf_tools/cpu_utils",["require","exports","modules/clean/js_client_stopwatch"],function(t,e,i){"use strict";function n(){var t=[];return window.ensemble&&window.ensemble.getJSStopwatchData&&(t=t.concat(a(window.ensemble.getJSStopwatchData()).map(function(t){return t.measurement}))),window.requireContexts&&(t=t.concat(r(window.requireContexts))),t}function o(t){if(t.require&&t.require.perfMeasurements){var e=0;return t.require.perfMeasurements.map(function(t){var i=t.name,n=t.startTime,o=t.totalTime;return i.endsWith("anon")&&(i+="-"+e++),{jsExecutionType:c(i),name:i,startTime:n,totalTime:o}})}var i=t.module_callback_times;return Object.keys(i).filter(function(t){return i[t].callbackDuration&&i[t].callbackTime}).map(function(t){return{jsExecutionType:c(t),name:t,startTime:i[t].callbackTime,totalTime:i[t].callbackDuration}})}function r(t){var e=[];for(var i in t)if(t.hasOwnProperty(i)){var n=t[i];e=e.concat(o(n))}return e}function a(t){return Object.keys(t).map(function(e){var i=t[e];return{measurement:{jsExecutionType:s(e),name:e,startTime:i.start,totalTime:i.end-i.start},annotations:i.annotations}})}function s(t){return t.startsWith("dws-processChunk")?d.DWS:d.UNKNOWN}function c(t){return t.startsWith("execCb.anon")||t.startsWith("overhead.anon")||t.startsWith("execCb.require-tier")||t.startsWith("overhead.require-tier")?d.OTHER:t.startsWith("execCb")||t.startsWith("overhead")?d.MODULE:d.UNKNOWN}function _(t,e){var i={},n=function(n){if(t.hasOwnProperty(n)){var o=t[n];i[n]={},e.forEach(function(t){0<t.startTime&&t.startTime<o&&(i[n][t.jsExecutionType]=i[n][t.jsExecutionType]||0,i[n][t.jsExecutionType]+=t.totalTime)})}};for(var o in t)n(o);return i}function l(t,e){var n=i.JSStopwatch.createDetachedStopwatch("cumulative_cpu_time",{correlation_id:t}),o=function(t){e.hasOwnProperty(t)&&p.forEach(function(i){n.recordTrace("cpu_before_"+t+"_due_to_"+i,e[t][i]||0)})};for(var r in e)o(r);n.logData()}function u(t,e){l(t,_(e,n()))}Object.defineProperty(e,"__esModule",{value:!0});var d;(function(t){t.DWS="dws",t.MODULE="module",t.OTHER="other",t.UNKNOWN="unknown"})(d=e.JSExecutionType||(e.JSExecutionType={}));var p=[d.DWS,d.MODULE,d.OTHER,d.UNKNOWN];e.listExecutionPerfMeasurementsForRequireContexts=r,e.listAnnotatedExecutionPerfMeasurementsForEnsemble=a,e.cumulativeExecutionTimesBefore=_,e.logCumulativeExecutionTimes=l,e.logAllGlobalCumulativeExecutionTimesByStageAndExecutionType=u}),define("modules/clean/perf_tools/resource_utils",["require","exports","modules/core/browser","modules/clean/js_client_stopwatch","modules/clean/perf_tools/cpu_utils"],function(t,e,i,n,o){"use strict";function r(t){c(t),s(t)}function a(t){if(p){if(p.href=t.name,p.host.match(/dropboxstatic.com$/)&&p.pathname.match(/^\/static/)){var e=p.pathname,i=e.match(/vfl[a-zA-Z0-9]*\.[a-z]*$/);i&&i.index&&(e=e.substring(0,i.index-1));for(var n=["/static/compiled/js/","/static/"],o=0,r=n;o<r.length;o++){var a=r[o];e.startsWith(a)&&(e=e.substring(a.length))}return e}return p.host.match(/photos-[0-9]+.dropbox.com$/)&&p.pathname.match(/^\/t\/2/)?"/thumbnail":void 0}}function s(t){var e=i.performance();if(e&&e.getEntriesByType){var o=n.JSStopwatch.createDetachedStopwatch("resource_timeline",{correlation_id:t}),r={},s=e.getEntriesByType("resource");if(s instanceof Array)for(var c=0,_=s;c<_.length;c++){var l=_[c],d=a(l);if(d){var p=r[d]||0;r[d]=p+1,p>0&&(d=d+"-"+p);var m=o.startSpan(d,{startTime:l.startTime,async:!0}),h=u(l);o.addSpanAnnotation(d,"type",h,m),0===l.transferSize?o.addSpanAnnotation(d,"cached","true",m):void 0===l.transferSize?o.addSpanAnnotation(d,"cached","unknown",m):o.addSpanAnnotation(d,"cached","false",m),l.responseEnd<l.startTime?(o.addSpanAnnotation(d,"negativeSpanLength",(l.responseEnd-l.startTime).toString(),m),o.endSpan(d,{endTime:l.startTime,spanId:m})):o.endSpan(d,{endTime:l.responseEnd,spanId:m})}}o.logData()}}function c(t){var e=window.requireContexts;if(e){var i=o.listExecutionPerfMeasurementsForRequireContexts(e),r=n.JSStopwatch.createDetachedStopwatch("resource_init_timeline",{correlation_id:t});i.forEach(function(t){var e=r.startSpan(t.name,{startTime:t.startTime});r.addSpanAnnotation(t.name,"totalTimeNs",Math.round(1e6*t.totalTime).toString(),e),r.endSpan(t.name,{endTime:t.startTime+t.totalTime,spanId:e})}),r.logData()}}function _(t){var e=i.performance();if(e&&e.getEntriesByType){var o=e.getEntriesByType("resource").filter(function(e){return e.name.indexOf(t)!==-1}),r=o[0];if(r&&r.responseEnd){var a="resource_response_end_"+t;return n.JSStopwatch.create_stopwatch_if_not_exist("resource_timing"),n.JSStopwatch.recordTrace(a,{stopwatchName:"resource_timing",traceTime:r.responseEnd}),r}}}function l(){var t={},e=i.performance();if(!e)return t;var o=e.getEntriesByType("resource");if(n.JSStopwatch.create_stopwatch_if_not_exist("resource_timeline"),o instanceof Array)for(var r=0,a=o;r<a.length;r++){var s=a[r],c=u(s);c in t||(t[c]={count:0,total_time:0}),t[c].count++,t[c].total_time+=s.duration,d(c)&&void 0!==s.encodedBodySize&&(t[c].total_size=t[c].total_size||0,t[c].total_size+=s.encodedBodySize),d(c)&&void 0!==s.transferSize&&(t[c].transfer_size=t[c].transfer_size||0,t[c].transfer_size+=s.transferSize)}return t}function u(t){var e=t.name,i=t.initiatorType,n=e.lastIndexOf(".");if(n>0){var o=e.substring(n);if([".png",".gif",".jpg",".svg"].indexOf(o)>-1)return"img";if(".js"===o)return"script";if(".css"===o)return"css"}return["css","img","script","link"].indexOf(i)===-1?"xmlhttprequest"===i?"ajax":"other":i}function d(t){return"css"===t||"script"===t||"img"===t}Object.defineProperty(e,"__esModule",{value:!0}),e.logResourcesData=r;var p=document&&document.createElement?document.createElement("a"):null;e.logResourceTiming=_,e.getResourceSummary=l}),define("modules/clean/perf_tools/web_timing_logger_types",["require","exports"],function(t,e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var i=(function(){function t(){}return t.getFromNavigation=function(e){switch(e.type){case e.TYPE_NAVIGATE:return t.NAVIGATE;case e.TYPE_RELOAD:return t.RELOAD;case e.TYPE_BACK_FORWARD:return t.BACK_FORWARD}},t.NAVIGATE="navigate",t.RELOAD="reload",t.BACK_FORWARD="back_forward",t})();e.NavigationType=i;var n=(function(){function t(e,i,n,o,r){void 0===n&&(n=!1),void 0===o&&(o=!0),this.name=e,this.flag=1<<i,this.triggersLogging=n,this.timestampPrefix=r||e,this.ordered=o,t.allEvents.push(this)}return t.allEvents=[],t.APPLICATION_START=new t("application_code_start",1),t.LOAD_END=new t("load_end",2,!0,!1),t.MARK_TIME_TO_VIEW=new t("mark_time_to_view",3,!0,!0,"TTV"),t.FETCHED_DATA_FOR_TTI=new t("fetched_data_required_for_tti",4),t.MARK_TIME_TO_INTERACTIVE=new t("mark_time_to_interactive",5),t.TIME_TO_INTERACTIVE=new t("time_to_interactive",6,!0,!0,"TTI"),t})();e.WebTimerEvent=n}),define("modules/clean/perf_tools/web_timing_utils",["require","exports","modules/core/browser"],function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var n=(function(){function t(){}return t.generateCorrelationId=function(){return Math.random().toString(36).substring(2)},t.getNow=function(){var t=i.performance();if(t&&t.timing&&t.now){var e=t.timing;return(e.navigationStart||e.fetchStart)+Math.floor(t.now())}return Date.now()},t.newContext=function(e,n){void 0===n&&(n="unnamed_timer");var o;if(e)o=t.getNow();else{var r=i.performance();if(r&&r.timing){var a=r.timing;o=a.navigationStart||a.fetchStart}else o=t.getNow()}return{initialized:!1,is_pagelet:!1,is_dws:!1,is_early_ensemble:!1,log_time_to_view:!1,log_time_to_interactive:!1,ttv_at_dom_interactive:!1,tti_at_dom_interactive:!1,source_type:"web",subtypes:{},tti_exclusion_flow:"",have_logged_web_timing:!1,delayed_tti_for_css:!1,timing_results:null,start_time:o,time_to_view:null,time_to_interactive:null,correlation_id:t.generateCorrelationId(),timesStagesWereReached:{},context_name:n}},t})();e.WebTimingUtil=n;var o=(function(){function t(t){this.canceled=!1,this.callback=t}return t.prototype.exec=function(){this.canceled||this.callback()},t.prototype.cancel=function(){this.canceled=!0},t.prototype.isCanceled=function(){return this.canceled},t})();e.CancellableCallback=o}),define("modules/clean/web_module_timing",["require","exports"],function(t,e){"use strict";var i={module_times:[],reset:function(){i.module_times=[]},get_module_times:function(){return i.module_times},add_module:function(t,e,n,o){var r={load_time:e,callback_duration:o,callback_time:n};t&&t.url&&(r.url=t.url),t&&t.id&&(r.name=t.id),t&&t.parentMap&&t.parentMap.url&&(r.parent=t.parentMap.url),i.module_times.push(r)}};return i}),define("modules/clean/web_timing_logger",["require","exports","tslib","modules/core/xhr","modules/clean/devtools/panels/performance/perf_hub_actions","modules/clean/event_load","modules/constants/request","modules/constants/webtiming","modules/constants/page_load","modules/core/browser","modules/core/exception","modules/clean/web_module_timing","modules/clean/window_util","modules/clean/perf_tools/resource_utils","modules/clean/perf_tools/web_timing_logger_types","modules/clean/perf_tools/web_timing_utils","modules/clean/js_client_stopwatch","modules/clean/perf_tools/browser_perf_utils","modules/clean/init_react","modules/clean/perf_tools/cpu_utils"],function(t,e,i,n,o,r,a,s,c,_,l,u,d,p,m,h,f,v,g,w){"use strict";function T(t){var e=t;return Z[e]||(Z[e]=new X(h.WebTimingUtil.newContext(!0,t))),Z[e]}function S(t){return t?T(t):tt}function E(t){delete Z[t]}function y(){return S().timeToView()}function b(){return S().timeToInteractive()}function x(t){void 0===t&&(t={}),S().initialize({requireTTV:!!t.log_time_to_view,requireTTI:!!t.log_time_to_interactive,is_pagelet:t.is_pagelet,is_dws:t.is_dws,is_early_ensemble:t.is_early_ensemble,ttv_at_dom_interactive:t.ttv_at_dom_interactive,tti_at_dom_interactive:t.tti_at_dom_interactive,source_type:t.source_type,subtypes:t.subtypes,tti_exclusion_flow:t.tti_exclusion_flow})}function I(){tt=new $(h.WebTimingUtil.newContext(!1,"default_timer"))}function A(){return S().startTime()}function N(){return S().timeSinceStart()}function O(t){S().excludeFromTTI(t)}function D(t,e){for(var i=0,n=e;i<n.length;i++){var o=n[i];if(0!==o.startTime){var r=t.startSpan(o.name,{startTime:o.startTime});if(void 0!==o.annotations)for(var a in o.annotations)o.annotations.hasOwnProperty(a)&&t.addSpanAnnotation(o.name,a,o.annotations[a],r);o.endTime<o.startTime?(t.addSpanAnnotation(o.name,"negativeSpanLength",(o.endTime-o.startTime).toString(),r),t.endSpan(o.name,{spanId:r,endTime:o.startTime})):t.endSpan(o.name,{spanId:r,endTime:o.endTime})}else t.recordTrace(o.name,o.endTime,o.annotations)}t.logData()}function R(t){if(window.ensemble&&window.ensemble.getJSStopwatchData){var e=window.ensemble.getJSStopwatchData();C(t.correlation_id,e);for(var i in e)e.hasOwnProperty(i)&&et.includes(i)&&(t.timesStagesWereReached[i]=e[i].start)}}function C(t,e){var i=w.listAnnotatedExecutionPerfMeasurementsForEnsemble(e);D(f.JSStopwatch.createDetachedStopwatch("ensemble",{correlation_id:t}),i.map(function(t){var e=t.measurement,i=t.annotations;return{name:e.name,startTime:e.startTime,endTime:e.startTime+e.totalTime,annotations:i}}))}function W(t){var e=g.getReactInitData();D(f.JSStopwatch.createDetachedStopwatch("init_react",{correlation_id:t}),e)}function k(){S().markTimeToView()}function M(t){void 0===t&&(t={});var e=S();e.setExtraColumns(t),e.markTimeToInteractive()}function L(){return S().waitForTTI()}function P(){S().applicationStart()}function q(){S().fetchedDataRequiredForTTI()}function U(t){var e=p.getResourceSummary();for(var i in e)e.hasOwnProperty(i)&&(t["resource_"+i+"_count"]=e[i].count,t["resource_"+i+"_avg_time"]=e[i].total_time/e[i].count,void 0!==e[i].total_size&&(t["resource_"+i+"_total_size"]=e[i].total_size),void 0!==e[i].transfer_size&&(t["resource_"+i+"_transfer_size"]=e[i].transfer_size))}function j(t){var e=f.JSStopwatch.createDetachedStopwatch("resources_percent_transferred",{correlation_id:t}),i=p.getResourceSummary();for(var n in i)if(i.hasOwnProperty(n)){var o=i[n].transfer_size,r=i[n].total_size;if(void 0!==o&&void 0!==r&&r>0){var a=Math.min(1,o/r);e.recordTrace("percent_"+n+"_transferred",100*a)}}e.logData()}function J(t){var e=_.performance();if(e&&e.getEntriesByName){for(var i=u.get_module_times(),n=[],o=0,r=i;o<r.length;o++){var a=r[o],s=a.url;if(void 0===s&&a.name&&a.name.indexOf("!")===-1)l.reportStack("Module "+a.name+" with invalid map object fetched by requirejs",{severity:l.SEVERITY.NONCRITICAL,tags:["log_js_module_timing"]});else{var c=[];if(s&&(c=e.getEntriesByName(s,"resource")),0!==c.length)a.start_time=c[0].responseEnd;else{if(!("callback_duration"in a))continue;a.start_time=0}n.push(a)}}t.js_module_times=JSON.stringify(n)}}function B(t){if(window.ensemble&&window.ensemble.markTTI)window.ensemble.markTTI();else{var e=document.createEvent("Event");void 0!=t?e.initEvent("TTI."+t,!0,!0):e.initEvent("TTI",!0,!0),window.dispatchEvent(e)}}Object.defineProperty(e,"__esModule",{value:!0}),e.ExtraColumns=m.ExtraColumns;var F;(function(t){t[t.NEW=1]="NEW",t[t.RUNNING=2]="RUNNING",t[t.ABORTED=3]="ABORTED",t[t.CLOSED=4]="CLOSED"})(F||(F={})),e.perfHubClassName="perf-hub-link-container";var V=[[m.WebTimerEvent.APPLICATION_START,m.WebTimerEvent.MARK_TIME_TO_VIEW,m.WebTimerEvent.FETCHED_DATA_FOR_TTI,m.WebTimerEvent.MARK_TIME_TO_INTERACTIVE],[m.WebTimerEvent.TIME_TO_INTERACTIVE]].reverse(),z=1,G=(function(){function t(){f.JSStopwatch.create_stopwatch_if_not_exist("web_timing_logger")}return t.prototype.buildBaseParams=function(t,e,i){void 0===i&&(i={});var n=t.start_time,o=t.subtypes||{};t.tti_flow&&(o.tti_flow=t.tti_flow);var r={log_source:e.name,subtypes:JSON.stringify(o),correlation_id:t.correlation_id};t.extra_columns&&Object.keys(t.extra_columns).forEach(function(e){var i=t.extra_columns[e];i&&(r[e]=i)}),Object.keys(i).forEach(function(t){var e=i[t];e&&(r[t]=e)}),a.IS_HTTP2&&(r.is_spdy=!0),t.is_pagelet&&(r.is_pagelet=!0),t.is_dws&&(r.is_dws=!0),t.is_early_ensemble&&(r.is_early_ensemble=!0),r.delayed_tti_for_css=t.delayed_tti_for_css,""!==t.tti_exclusion_flow&&(r.tti_exclusion_flow=t.tti_exclusion_flow);var s;s=t.log_time_to_view&&null!=t.time_to_view?t.time_to_view-n:null;var _;_=t.log_time_to_interactive&&null!=t.time_to_interactive?t.time_to_interactive-n:null;var l={navigation_type:this.get_navigation_type(),server_request_start_time:a.REQUEST_START_TIME,extra_columns:JSON.stringify(r),subtypes:JSON.stringify(o),source_type:t.source_type,page_load_time:t.end_time-t.start_time};return J(l),l.repo_rev=c.REPO_REV,t.log_time_to_view&&(l.time_to_view=s),t.log_time_to_interactive&&(l.time_to_interactive=_),t.request_id&&(l.request_id=t.request_id),l},t.prototype.get_navigation_type=function(){var t=_.performance();if(t&&t.navigation){var e=t.navigation;return m.NavigationType.getFromNavigation(e)}},t.prototype.log=function(t,i,r){void 0===r&&(r=!1);var s=f.JSStopwatch.startSpan("wtl_endpoint",{stopwatchName:"web_timing_logger"});if(f.JSStopwatch.addSpanAnnotation("wtl_endpoint","navigation_type",t.navigation_type,{stopwatchName:"web_timing_logger",spanId:s}),t.url=_.get_href(),t.referrer=document.referrer,t.request_id=t.request_id||a.REQUEST_ID,t.request_tracing_enabled=a.REQUEST_TRACING_ENABLED,null!=i&&(t.url_info=i),window.ensemble&&window.ensemble.viewer){var c=window.ensemble.viewer.getActiveUser();c&&(t.active_user_id=c.userId)}var l=n.sendXhr("/alternate_wtl",t);l.onreadystatechange=function(t){if(l.readyState===XMLHttpRequest.DONE&&200===l.status){f.JSStopwatch.endSpan("wtl_endpoint",{stopwatchName:"web_timing_logger",spanId:s});var i=document.getElementsByClassName(e.perfHubClassName);if(r&&i.length){var n=JSON.parse(l.responseText);n.status&&o.PerfHubActions.add_web_timing_details(n)}}}},t})(),K=(function(t){function e(){return t.call(this)||this}return i.__extends(e,t),e.prototype.shouldLog=function(t){return t.initialized&&!t.have_logged_web_timing&&void 0!==t.end_time&&(!t.log_time_to_view||null!=t.time_to_view)&&(!t.log_time_to_interactive||null!=t.time_to_interactive)},e.prototype.logTiming=function(t,e){t.have_logged_web_timing=!0;var i=this.buildBaseParams(t,e);this.log(i,void 0,!1)},e.prototype.get_navigation_type=function(){return"ajax"},e})(G),H=(function(t){function e(){return t.call(this)||this}return i.__extends(e,t),e.prototype.shouldLog=function(t){if(!t.initialized||t.have_logged_web_timing)return!1;var e=_.performance();if(!e||!e.timing)return!1;var i=e.timing,n=t.start_time,o=t.end_time;return!(!n||!o)&&(!(t.log_time_to_view&&!(t.ttv_at_dom_interactive&&i.domInteractive||null!=t.time_to_view))&&!(t.log_time_to_interactive&&!(t.tti_at_dom_interactive&&i.domInteractive||null!=t.time_to_interactive)))},e.prototype.logTiming=function(t,e){var i=_.performance().timing;f.JSStopwatch.startSpan("process_nav_timing",{stopwatchName:"web_timing_logger"});var n={},o=this.buildBaseParams(t,e,n);o.browser_time=(i.redirectStart||i.fetchStart)-t.start_time,o.redirect_time=i.fetchStart-t.start_time,o.dns_time=i.domainLookupEnd-t.start_time,o.tcp_connect_time=(i.secureConnectionStart||i.requestStart)-t.start_time,o.ssl_connect_time=i.requestStart-t.start_time,o.time_to_first_byte=i.responseStart-t.start_time,o.time_to_last_byte=i.responseEnd-t.start_time,o.dom_load_time=i.domContentLoadedEventEnd-t.start_time,o.idle_cpu_time=t.timing_results?Math.round(t.timing_results.idleCPUTime):void 0,o.total_tracked_cpu_time=t.timing_results?Math.round(t.timing_results.totalTrackedCPUTime):void 0,o.untracked_time_after_first_byte=t.timing_results&&null!=t.timing_results.untrackedTimeAfterFirstByte?Math.round(t.timing_results.untrackedTimeAfterFirstByte):void 0,_.performance().getEntriesByType&&(U(o),j(t.correlation_id),f.JSStopwatch.addSpanAnnotation("process_nav_timing","logged_resources","1",{stopwatchName:"web_timing_logger"})),J(o),f.JSStopwatch.addSpanAnnotation("process_nav_timing","logged_modules","1",{stopwatchName:"web_timing_logger"}),f.JSStopwatch.endSpan("process_nav_timing",{stopwatchName:"web_timing_logger"}),t.is_pagelet&&R(t),v.logBrowserPerfData(t.correlation_id),w.logAllGlobalCumulativeExecutionTimesByStageAndExecutionType(t.correlation_id,t.timesStagesWereReached),(this.get_navigation_type()===m.NavigationType.NAVIGATE||s.LOG_NON_NAVIGATION_RESOURCES)&&(W(t.correlation_id),p.logResourcesData(t.correlation_id)),f.JSStopwatch.log_stored_results(),t.have_logged_web_timing=!0,this.log(o,void 0,!0)},e})(G),Y=(function(){function t(t,e,i,n){this.childSpans=[],this.spanName=t,this.startTime=void 0!==i?i:h.WebTimingUtil.getNow(),this.originTs=e,this.startTimeOffsetMS=this.startTime-e,this.endCallback=n}return t.prototype.startSpan=function(e){var i=new t(e,this.originTs);return this.childSpans.push(i),i},t.prototype.markSpan=function(e,i){var n=new t(e,this.originTs,this.startTime);this.childSpans.push(n),n.endSpan(i)},t.prototype.endSpan=function(t){var e=this;this.endTime=void 0!==t?t:h.WebTimingUtil.getNow(),this.childSpans.forEach(function(t){t.hasEnded()||t.endSpan(e.endTime)}),this.endCallback&&this.endCallback(this)},t.prototype.getEndTimeOffsetMS=function(){return void 0!==this.endTime?this.endTime-this.originTs:void 0},t.prototype.hasEnded=function(){return void 0!==this.endTime},t})(),Q=(function(){function t(t,e,i,n){void 0===n&&(n=!1),this.timerState=F.RUNNING,this.loggedEvents=0,this.activeSpans=[],this.endedSpans=[],this.context=t,this.timingStopwatch=e,this.userStopwatch=i,this.id=z++,this.strictAssert=n}return t.prototype.startSpan=function(t){var e=this,i=new Y(t,this.context.start_time,void 0,function(t){e.endSpan(t)});return this.activeSpans.push(i),i},t.prototype.markSpan=function(t,e){if(void 0===e&&(e={}),this.userStopwatch){
var i=void 0===e.startTime?0:e.startTime,n=this.timeSinceStart(e.endTime),o=this.userStopwatch.startSpan(t,{startTime:i});this.userStopwatch.endSpan(t,{spanId:o,endTime:n})}else{var r=new Y(t,this.context.start_time,e.startTime);r.endSpan(e.endTime),this.endedSpans.push(r)}},t.prototype.endSpan=function(t){var e=this.activeSpans.indexOf(t);e>=0&&(delete this.activeSpans[e],this.userStopwatch?this.recordSpan(t):this.endedSpans.push(t))},t.prototype.recordSpan=function(t){var e=this,i=this.userStopwatch.startSpan(t.spanName,{startTime:t.startTimeOffsetMS});t.childSpans.forEach(function(t){e.recordSpan(t)}),this.userStopwatch.endSpan(t.spanName,{spanId:i,endTime:t.getEndTimeOffsetMS()})},t.prototype.getContextName=function(){return this.context.context_name},t.prototype.applicationStart=function(){this.logEvent(m.WebTimerEvent.APPLICATION_START)},t.prototype.fetchedDataRequiredForTTI=function(){this.logEvent(m.WebTimerEvent.FETCHED_DATA_FOR_TTI)},t.prototype.startTime=function(){return this.context.start_time},t.prototype.timeSinceStart=function(t){return(t||h.WebTimingUtil.getNow())-this.context.start_time},t.prototype.timeToView=function(){return this.context.time_to_view},t.prototype.timeToInteractive=function(){return this.context.time_to_interactive},t.prototype.reportTTIAfterPaint=function(){var t=this,e=new h.CancellableCallback(function(){t.reportTTI()});return window.requestAnimationFrame(function(){window.requestAnimationFrame(function(){e.exec()})}),e},t.prototype.setExtraColumns=function(t){this.context.extra_columns=t},t.prototype.excludeFromTTI=function(t){""!==this.context.tti_exclusion_flow&&(this.context.tti_exclusion_flow=this.context.tti_exclusion_flow+","),this.context.tti_exclusion_flow=this.context.tti_exclusion_flow+t},t.prototype.logEvent=function(t,e){this.logEventInternal(t,!0,e)},t.prototype.logSilentEvent=function(t,e){this.logEventInternal(t,!1,e)},t.prototype.logEventInternal=function(t,e,i){this.loggedEvents|=t.flag,t.ordered&&this.validateEventOrder(t);var n=this.timeSinceStart(i);this.context.timesStagesWereReached[t.name]=n,this.timingStopwatch.recordTrace(t.name,n),console.timeStamp&&console.timeStamp(t.timestampPrefix),e&&t.triggersLogging&&this.logIfReady(t)},t.prototype.validateEventOrder=function(t){for(var e=0,i=0,n=V;i<n.length;i++){var o=n[i];if(o.includes(t))break;for(var r=0,a=o;r<a.length;r++){e|=a[r].flag}}var s=e&this.loggedEvents;if(s>0){var c=m.WebTimerEvent.allEvents.filter(function(t){return(t.flag&s)>0}).map(function(t){return t.name});this.reportSwMisuse("Received "+t.name+" after ["+c.join(",")+"]")}},t.prototype.logIfReady=function(t){this.logger.shouldLog(this.context)&&(this.addEventBasedTiming(),this.timingStopwatch.logData(),this.userStopwatch.logData(),this.logger.logTiming(this.context,t),this.timerState=F.CLOSED)},t.prototype.addEventBasedTiming=function(){var t=_.performance().timing;this.context.ttv_at_dom_interactive&&(this.context.is_pagelet&&window.ensemble?this.context.time_to_view=window.ensemble.getEmbeddedAppDOMInteractive():this.context.time_to_view=t.domInteractive,this.logSilentEvent(m.WebTimerEvent.MARK_TIME_TO_VIEW,this.context.time_to_view)),this.context.tti_at_dom_interactive&&(this.context.time_to_interactive=t.domInteractive,this.logSilentEvent(m.WebTimerEvent.MARK_TIME_TO_INTERACTIVE,this.context.time_to_interactive),this.logSilentEvent(m.WebTimerEvent.TIME_TO_INTERACTIVE,this.context.time_to_interactive))},t.prototype.reportSwMisuse=function(t){t="WebTimer: "+t,this.strictAssert?l.assert(!1,t):l.reportStack(t,{severity:l.SEVERITY.NONCRITICAL,tags:["web_timing_logger"]})},t})(),X=(function(t){function e(e){var i=t.call(this,e,f.JSStopwatch.createDetachedStopwatch("maestro_tracing",{correlation_id:e.correlation_id}),f.JSStopwatch.createDetachedStopwatch("user_tracing",{correlation_id:e.correlation_id}),!1)||this;return i.logger=new K,i}return i.__extends(e,t),e.prototype.initialize=function(t){this.context.initialized||(this.context.initialized=!0,this.context.log_time_to_view=t.requireTTV,this.context.log_time_to_interactive=t.requireTTI,this.context.tti_flow=t.url,this.timingStopwatch.url=this.context.tti_flow,this.userStopwatch.url=this.context.tti_flow)},e.prototype.start=function(){this.isUsable()&&this.timerState===F.NEW&&(this.context.start_time=h.WebTimingUtil.getNow(),this.timerState=F.RUNNING)},e.prototype.restart=function(){this.TTICallback&&(this.TTICallback.cancel(),this.TTICallback=void 0),this.loggedEvents=0,this.context.correlation_id=h.WebTimingUtil.generateCorrelationId(),this.context.start_time=h.WebTimingUtil.getNow(),this.context.end_time=void 0,this.context.time_to_view=null,this.context.time_to_interactive=null,this.timerState=F.RUNNING,this.timingStopwatch=f.JSStopwatch.createDetachedStopwatch("maestro_tracing",{url:this.context.tti_flow,correlation_id:this.context.correlation_id}),this.userStopwatch=f.JSStopwatch.createDetachedStopwatch("user_tracing",{url:this.context.tti_flow,correlation_id:this.context.correlation_id})},e.prototype.abort=function(){this.timerState!==F.CLOSED&&(this.timerState=F.ABORTED)},e.prototype.markTimeToView=function(){this.isUsable()&&(null==this.context.time_to_view&&(this.context.time_to_view=h.WebTimingUtil.getNow()),this.logEvent(m.WebTimerEvent.MARK_TIME_TO_VIEW))},e.prototype.markTimeToInteractive=function(){this.isUsable()&&(this.logEvent(m.WebTimerEvent.MARK_TIME_TO_INTERACTIVE),_.is_page_content_hidden()?this.reportTTI():this.TTICallback=this.reportTTIAfterPaint())},e.prototype.reportTTI=function(){null==this.context.time_to_interactive&&(this.context.time_to_interactive=h.WebTimingUtil.getNow(),this.logEvent(m.WebTimerEvent.TIME_TO_INTERACTIVE),B(this.id))},e.prototype.end=function(t){this.isUsable()&&(void 0===this.context.end_time&&(this.context.end_time=h.WebTimingUtil.getNow()),this.context.request_id=t,this.timingStopwatch.request_id=t,this.userStopwatch.request_id=t,this.logEvent(m.WebTimerEvent.LOAD_END))},e.prototype.waitForTTI=function(){var t=this;return new Promise(function(e,i){if(null!=t.context.time_to_interactive)return void e();var n=function(i){window.removeEventListener("TTI."+t.id,n),e()};window.addEventListener("TTI."+t.id,n)})},e.prototype.isUsable=function(){return this.timerState===F.NEW||this.timerState===F.RUNNING},e})(Q),$=(function(t){function e(e){var i=t.call(this,e,f.JSStopwatch.createDetachedStopwatch("maestro_tracing",{correlation_id:e.correlation_id}),f.JSStopwatch.createDetachedStopwatch("user_tracing",{correlation_id:e.correlation_id}),!1)||this;return i.logger=new H,i}return i.__extends(e,t),e.prototype.initialize=function(t){var e=this;if(!this.context.initialized){if(!_.performance())return;this.context.log_time_to_view=t.requireTTV,this.context.log_time_to_interactive=t.requireTTI,this.context.is_pagelet=!!t.is_pagelet,this.context.is_dws=!!t.is_dws,this.context.is_early_ensemble=!!t.is_early_ensemble,this.context.ttv_at_dom_interactive=!!t.ttv_at_dom_interactive,this.context.tti_at_dom_interactive=!!t.tti_at_dom_interactive,this.context.source_type=null!=t.source_type?t.source_type:"web",this.context.subtypes=null!=t.subtypes?t.subtypes:{},this.context.tti_exclusion_flow=null!=t.tti_exclusion_flow?t.tti_exclusion_flow:"",this.context.have_logged_web_timing=!1,this.context.delayed_tti_for_css=!1,this.context.initialized=!0;var i=0;s.LOG_TIMING_DELAY&&(i=600),f.JSStopwatch.create_stopwatch_if_not_exist("web_timing_logger"),r.window_load(function(){setTimeout(function(){return e.end()},i)}),d.onPageRestore(function(t){var i=f.JSStopwatch.createDetachedStopwatch("browser_perf",{correlation_id:e.context.correlation_id});i.recordTrace("page_restore"),i.logData()}),!this.context.ttv_at_dom_interactive&&window._timingData&&(null!=window._timingData.ttv&&(this.context.time_to_view=window._timingData.ttv.getTime(),this.logEvent(m.WebTimerEvent.MARK_TIME_TO_VIEW,this.context.time_to_view)),null!=window._timingData.tti&&(this.context.time_to_interactive=window._timingData.tti.getTime(),this.logEvent(m.WebTimerEvent.TIME_TO_INTERACTIVE,this.context.time_to_interactive),B()))}},e.prototype.start=function(){this.isUsable()&&this.timerState===F.NEW&&(this.timerState=F.RUNNING)},e.prototype.restart=function(){this.TTICallback&&(this.TTICallback.cancel(),this.TTICallback=void 0),this.loggedEvents=0,this.context.correlation_id=h.WebTimingUtil.generateCorrelationId(),this.context.end_time=void 0,this.context.time_to_view=null,this.context.time_to_interactive=null,this.timerState=F.RUNNING,this.timingStopwatch=f.JSStopwatch.createDetachedStopwatch("maestro_tracing",{correlation_id:this.context.correlation_id}),this.userStopwatch=f.JSStopwatch.createDetachedStopwatch("user_tracing",{correlation_id:this.context.correlation_id})},e.prototype.abort=function(){this.timerState!==F.CLOSED&&(this.timerState=F.ABORTED)},e.prototype.markTimeToView=function(){this.isUsable()&&(null!=this.context.time_to_view||this.context.ttv_at_dom_interactive||(window._timingData&&null!=window._timingData.ttv?this.context.time_to_view=window._timingData.ttv.getTime():this.context.time_to_view=h.WebTimingUtil.getNow(),this.logEvent(m.WebTimerEvent.MARK_TIME_TO_VIEW,this.context.time_to_view)))},e.prototype.markTimeToInteractive=function(){var t=this;if(window.ensemble&&window.ensemble.waitingForCss)return this.context.delayed_tti_for_css=!0,void(window.ensemble.mark_tti_callback=function(){t.markTimeToInteractive()});null!=this.context.time_to_interactive||this.context.tti_at_dom_interactive||(this.logEvent(m.WebTimerEvent.MARK_TIME_TO_INTERACTIVE),_.is_page_content_hidden()?this.reportTTI():this.TTICallback=this.reportTTIAfterPaint())},e.prototype.reportTTI=function(){null==this.context.time_to_interactive&&(window._timingData&&null!=window._timingData.tti?this.context.time_to_interactive=window._timingData.tti.getTime():this.context.time_to_interactive=h.WebTimingUtil.getNow(),console.timeStamp&&console.timeStamp("TTI"),window.ensemble&&window.ensemble.snapshotTimingProfile&&(this.context.timing_results=window.ensemble.snapshotTimingProfile()||null),this.logEvent(m.WebTimerEvent.TIME_TO_INTERACTIVE,this.context.time_to_interactive),B())},e.prototype.end=function(t){this.isUsable()&&void 0===this.context.end_time&&(this.context.end_time=h.WebTimingUtil.getNow(),this.logEvent(m.WebTimerEvent.LOAD_END),this.context.tti_at_dom_interactive&&B())},e.prototype.waitForTTI=function(){var t=this;return new Promise(function(e,i){if(window.ensemble){if(window.ensemble.ttiMarked)return void e()}else if(null!=t.context.time_to_interactive)return void e();var n=function(t){window.removeEventListener("TTI",n),e()};window.addEventListener("TTI",n)})},e.prototype.isUsable=function(){return this.timerState===F.NEW||this.timerState===F.RUNNING},e})(Q),Z={},tt=new $(h.WebTimingUtil.newContext(!1,"default_timer"));e.get_timer=S,e.delete_timer=E,e.time_to_view=y,e.time_to_interactive=b,e.initialize_module=x,e.reset=I,e.start_time=A,e.time_since_start=N,e.set_tti_exclusion_flow=O;var et=["ensemble_init","dws_ensemble_init","dws_embedded-app_require_config_callback","dws-processChunk-embedded-app-require_config-1"];e.logEnsembleStopwatch=C,e.mark_time_to_view=k,e.mark_time_to_interactive=M,e.waitForTTI=L,e.log_js_modules_application_code_start=P,e.log_js_modules_fetched_data_required_for_tti=q}),define("modules/clean/window_util",["require","exports"],function(t,e){"use strict";function i(t){function e(){t(),window.removeEventListener("beforeunload",e)}window.addEventListener("beforeunload",e)}function n(t){function e(i){i.persisted&&(t(),window.removeEventListener("pageshow",e))}window.addEventListener("pageshow",e)}Object.defineProperty(e,"__esModule",{value:!0}),e.onBeforeUnload=i,e.onPageRestore=n});
//# sourceMappingURL=pkg-timing.min.js-vflVuadxr.map